#define PIN_COUNT 4
char pins[PIN_COUNT]={3,4,5,6};
#define PIN_MAX ((1<<PIN_COUNT)-1)
//1024 <> 5V, const is full scale/1024
//for I, 5V ~ 6.67A
#define I_CONST (0.0065104)
//for V, 33k/10k => 5V ~ 21.5V
#define V_CONST (0.0209961)
#define I_PIN (A1)
#define V_PIN (A0)
#define R_CONST (47.0)
#define MODE_MANUAL ('m')
#define MODE_CURRENT ('i')
#define MODE_RESISTANCE ('r')
#define TMOUT (200)

int u=0;      //number of load units active
int mode=MODE_MANUAL;
float setp=0;
unsigned long tmout=0;
float i,v;
#define BUF_LEN 100
char inbuf[BUF_LEN]="";

void setup() {
  int k;
  for(k=0;k<PIN_COUNT;k++){
    digitalWrite(pins[k],LOW);
    pinMode(pins[k],OUTPUT);
  }
  Serial.begin(115200);
}


void loop() {
  int d;
  if(Serial.available()){
    d=Serial.read();
    if(d>=' '){
      addToBuf(inbuf,d);
    }else{
      if(d==13){
        dobuf();
        inbuf[0]=0; //clear
      }
    }
  }
  if((millis()-tmout)>TMOUT){
    tmout=millis();
    i=analogRead(I_PIN)*I_CONST;
    v=analogRead(V_PIN)*V_CONST;
    if(mode==MODE_MANUAL){
      setPins(setp);    //setPins can handle out of range
    }else if(mode==MODE_CURRENT){
      if(i<setp){setPins(u+1);}  //more current
      if(i>setp){setPins(u-1);}  //less current
    }else if(mode==MODE_RESISTANCE){
      if(setp<(R_CONST/PIN_MAX)){//this handles negative values and div/0
          setPins(PIN_MAX);
        }else{
          setPins((R_CONST/setp)+0.5);  //this gives the closest geometrically
        }
    }else{
        setPins(0);   //failsafe
    }
    Serial.print("Mode:");
    Serial.write(mode);
    Serial.print(",Setpoint:");
    Serial.print(setp);
    Serial.print(",");
    Serial.print(i,2);
    Serial.print("A,");
    Serial.print(v,2);
    Serial.print("V,");
    Serial.print(v*i,2);
    Serial.print("W,");
    Serial.print(u);
    Serial.print(" unit loads,");
    if(u==0){
      Serial.println("Open circuit");
    }else{
      Serial.print(R_CONST/u);
      Serial.println("Ohms");
    }
  }
}

int setPins(int r){
  int i;
  if(r<0){r=0;}
  if(r>PIN_MAX){r=PIN_MAX;}
  u=r;
  //all low first
//  for(i=0;i<PIN_COUNT;i++){digitalWrite(pins[i],LOW);}
  //set any low, than any high
  for(i=0;i<PIN_COUNT;i++){
    if((r&(1<<i))==0){
      digitalWrite(pins[i],LOW);
    }
  }
  for(i=0;i<PIN_COUNT;i++){
    if(r&(1<<i)){
      digitalWrite(pins[i],HIGH);
    }
  }
  return r;
}

void addToBuf(char* dst, char dat){
  int p=strlen(dst);
  if(p<(BUF_LEN-2)){
    dst[p]=dat;
    dst[p+1]=0;
  }
}

void dobuf(){
  int p=strlen(inbuf);
  int i=0;
  while(i<p){
    if(inbuf[i]==MODE_MANUAL){mode=MODE_MANUAL;}
    if(inbuf[i]==MODE_CURRENT){mode=MODE_CURRENT;}
    if(inbuf[i]==MODE_RESISTANCE){mode=MODE_RESISTANCE;}
    if(inbuf[i]<'A'){ //end of modes and start of numbers
      setp=atof(&inbuf[i]);
      return;   //that's all we need to do
    }
    i++;
  }  
}
